<!-- WhatsApp QR Code Modal -->
<div class="modal fade" id="whatsappQrModal" tabindex="-1" role="dialog" aria-labelledby="whatsappQrModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(135deg, #25d366 0%, #128c7e 100%); color: white;">
                <h5 class="modal-title" id="whatsappQrModalLabel">
                    <i class="fab fa-whatsapp mr-2"></i>Send via WhatsApp
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- QR Code Section -->
                    <div class="col-md-6 text-center">
                        <h6 class="text-center mb-3">
                            <i class="fas fa-qrcode mr-2"></i>Scan QR Code
                        </h6>
                        <div class="qr-container mb-3">
                            <img id="whatsappQrImage" src="" alt="WhatsApp QR Code" class="img-fluid border rounded" style="max-width: 250px; min-height: 250px; background: #f8f9fa;">
                        </div>
                        <div class="btn-group w-100 mb-3" role="group">
                            <button type="button" class="btn btn-outline-primary btn-sm" onclick="downloadQrCode()">
                                <i class="fas fa-download mr-1"></i>Download
                            </button>
                            <button type="button" class="btn btn-outline-success btn-sm" onclick="copyQrLink()">
                                <i class="fas fa-copy mr-1"></i>Copy Link
                            </button>
                            <button type="button" class="btn btn-outline-info btn-sm" onclick="refreshQrCode()">
                                <i class="fas fa-refresh mr-1"></i>Refresh
                            </button>
                        </div>
                        <p class="small text-muted">Point your phone camera at the QR code to open WhatsApp</p>
                    </div>
                    
                    <!-- Message Preview Section -->
                    <div class="col-md-6">
                        <h6 class="mb-3">
                            <i class="fas fa-comment-dots mr-2"></i>Message Preview
                        </h6>
                        <div class="whatsapp-preview-container">
                            <div class="whatsapp-message" id="whatsappMessagePreview">
                                <!-- Message content will be populated here -->
                            </div>
                        </div>
                        
                        <div class="customer-info mt-3">
                            <h6><i class="fas fa-user mr-2"></i>Customer Details</h6>
                            <div class="info-item">
                                <strong>Name:</strong> <span id="customerName">-</span>
                            </div>
                            <div class="info-item">
                                <strong>Phone:</strong> <span id="customerPhone">-</span>
                            </div>
                            <div class="info-item">
                                <strong>Invoice:</strong> <span id="invoiceNumber">-</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="w-100">
                    <div class="row">
                        <div class="col-6">
                            <button type="button" class="btn btn-secondary btn-block" data-dismiss="modal">
                                <i class="fas fa-times mr-2"></i>Close
                            </button>
                        </div>
                        <div class="col-6">
                            <a id="whatsappDirectLink" href="#" target="_blank" class="btn btn-success btn-block">
                                <i class="fab fa-whatsapp mr-2"></i>Open WhatsApp
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.whatsapp-preview-container {
    background: #e5ddd5;
    padding: 15px;
    border-radius: 8px;
    max-height: 300px;
    overflow-y: auto;
}

.whatsapp-message {
    background: #dcf8c6;
    padding: 12px;
    border-radius: 8px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    font-size: 14px;
    line-height: 1.4;
    white-space: pre-line;
    position: relative;
    margin-left: auto;
    margin-right: 0;
    max-width: 80%;
    word-wrap: break-word;
}

.whatsapp-message::after {
    content: '';
    position: absolute;
    right: -8px;
    bottom: 6px;
    border-left: 8px solid #dcf8c6;
    border-top: 8px solid transparent;
    border-bottom: 8px solid transparent;
}

.info-item {
    padding: 3px 0;
    border-bottom: 1px solid #e9ecef;
}

.info-item:last-child {
    border-bottom: none;
}

.qr-container {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    border: 2px dashed #dee2e6;
}

#whatsappQrImage {
    transition: all 0.3s ease;
}

#whatsappQrImage:hover {
    transform: scale(1.05);
}
</style>

<script>
let currentQrData = {};

function showWhatsAppQr(data) {
    currentQrData = data;
    
    // Update customer info
    $('#customerName').text(data.customer_name || 'N/A');
    $('#customerPhone').text(data.phone || 'N/A');
    $('#invoiceNumber').text(data.invoice_number || 'N/A');
    
    // Update message preview
    $('#whatsappMessagePreview').text(data.message || 'No message');
    
    // Update QR code
    $('#whatsappQrImage').attr('src', data.qr_code_url || '');
    
    // Update direct link
    $('#whatsappDirectLink').attr('href', data.whatsapp_url || '#');
    
    // Show modal
    $('#whatsappQrModal').modal('show');
}

function downloadQrCode() {
    if (currentQrData.qr_code_url) {
        const link = document.createElement('a');
        link.href = currentQrData.qr_code_url;
        link.download = `whatsapp-qr-${currentQrData.invoice_number || 'message'}.png`;
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        
        toastr.success('QR code download started!');
    }
}

function copyQrLink() {
    if (currentQrData.whatsapp_url) {
        navigator.clipboard.writeText(currentQrData.whatsapp_url).then(() => {
            toastr.success('WhatsApp link copied to clipboard!');
        }).catch(() => {
            // Fallback for older browsers
            const textArea = document.createElement('textarea');
            textArea.value = currentQrData.whatsapp_url;
            document.body.appendChild(textArea);
            textArea.select();
            document.execCommand('copy');
            document.body.removeChild(textArea);
            toastr.success('WhatsApp link copied to clipboard!');
        });
    }
}

function refreshQrCode() {
    if (currentQrData.qr_code_url_alt) {
        $('#whatsappQrImage').attr('src', currentQrData.qr_code_url_alt);
        toastr.info('QR code refreshed with alternative provider');
    } else {
        // Add timestamp to force refresh
        const newUrl = currentQrData.qr_code_url + '&t=' + Date.now();
        $('#whatsappQrImage').attr('src', newUrl);
        toastr.info('QR code refreshed');
    }
}

// Function to generate QR for invoice
function generateInvoiceWhatsApp(phone, customerName, invoiceNumber, items, total, currency = 'BDT') {
    // This would typically call your backend service
    // For now, we'll create a simple example
    const message = `🧾 *Invoice #${invoiceNumber}*\n\n` +
                   `👤 *Customer:* ${customerName}\n` +
                   `📞 *Phone:* ${phone}\n` +
                   `📅 *Date:* ${new Date().toLocaleDateString()}\n\n` +
                   `📦 *Items:*\n${items}\n\n` +
                   `💰 *Total Amount:* ${currency} ${total}\n\n` +
                   `🙏 *Thank you for your business!*`;
    
    const encodedMessage = encodeURIComponent(message);
    const whatsappUrl = `https://wa.me/${phone.replace(/[^0-9]/g, '')}?text=${encodedMessage}`;
    const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=${encodeURIComponent(whatsappUrl)}`;
    const qrUrlAlt = `https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl=${encodeURIComponent(whatsappUrl)}&choe=UTF-8`;
    
    const data = {
        customer_name: customerName,
        phone: phone,
        invoice_number: invoiceNumber,
        message: message,
        whatsapp_url: whatsappUrl,
        qr_code_url: qrUrl,
        qr_code_url_alt: qrUrlAlt
    };
    
    showWhatsAppQr(data);
}
</script>